/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.api.registry.registrate.SimpleBuilder;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.data.CreateBlockEntityBuilder;
import com.simibubi.create.foundation.data.CreateEntityBuilder;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.VirtualFluidBuilder;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.dragons.createdragonsplus.common.registrate.builder.ArmInteractionPointBuilder;
import plus.dragons.createdragonsplus.common.registrate.builder.CustomStatBuilder;
import plus.dragons.createdragonsplus.data.lang.ForeignLanguageProvider;
import plus.dragons.createdragonsplus.data.tag.IntrinsicTagRegistry;
import plus.dragons.createdragonsplus.data.tag.ItemTagRegistry;
import plus.dragons.createdragonsplus.data.tag.TagRegistry;
import plus.dragons.createdragonsplus.mixin.neoforge.ExistingFileHelperAccessor;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(value={CreateRegistrate.class}, source={"create"}, license={"mit"})
public class CDPRegistrate
extends AbstractRegistrate<CDPRegistrate> {
    protected final Logger logger;
    protected final Map<Holder<?>, Holder<CreativeModeTab>> creativeModeTabLookup = new HashMap();
    @Nullable
    protected Holder<CreativeModeTab> creativeModeTab;
    @Nullable
    protected Function<Item, TooltipModifier> tooltipModifier;
    @Nullable
    protected ExistingFileHelper existingFileHelper;
    @Nullable
    protected String templateLocale;

    public CDPRegistrate(String modid) {
        super(modid);
        this.defaultCreativeTab(null);
        this.logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getSimpleName() + "[" + modid + "]"));
    }

    public final ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModid(), (String)path);
    }

    public boolean isInCreativeModeTab(Holder<?> holder) {
        return this.creativeModeTabLookup.containsKey(holder);
    }

    @Nullable
    public Holder<CreativeModeTab> getCreativeModeTab(Holder<?> holder) {
        return this.creativeModeTabLookup.get(holder);
    }

    public CDPRegistrate setCreativeModeTab(@Nullable Holder<CreativeModeTab> creativeModeTab) {
        this.creativeModeTab = creativeModeTab;
        return this;
    }

    public CDPRegistrate setTooltipModifier(@Nullable Function<Item, TooltipModifier> tooltipModifier) {
        this.tooltipModifier = tooltipModifier;
        return this;
    }

    protected <R, T extends R> RegistryEntry<R, T> accept(String name, ResourceKey<? extends Registry<R>> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<DeferredHolder<R, T>, ? extends RegistryEntry<R, T>> entryFactory) {
        RegistryEntry entry = super.accept(name, type, builder, creator, entryFactory);
        if (type.equals((Object)Registries.ITEM) && this.tooltipModifier != null) {
            Function<Item, TooltipModifier> tooltipModifier = this.tooltipModifier;
            this.addRegisterCallback(name, Registries.ITEM, item -> {
                TooltipModifier modifier = (TooltipModifier)tooltipModifier.apply((Item)item);
                TooltipModifier.REGISTRY.register(item, (Object)modifier);
            });
        }
        if (this.creativeModeTab != null) {
            this.creativeModeTabLookup.put((Holder<?>)entry, this.creativeModeTab);
        }
        return entry;
    }

    public <T, P extends RegistrateTagsProvider<T>> CDPRegistrate registerTags(ProviderType<P> type, TagRegistry<T, P> registry) {
        this.addDataGenerator(type, registry::generate);
        return this;
    }

    public CDPRegistrate registerEnchantmentTags(TagRegistry<Enchantment, RegistrateTagsProvider<Enchantment>> registry) {
        this.addDataGenerator(ProviderType.ENCHANTMENT_TAGS, registry::generate);
        return this;
    }

    public CDPRegistrate registerBlockTags(IntrinsicTagRegistry<Block, RegistrateTagsProvider.IntrinsicImpl<Block>> registry) {
        this.addDataGenerator(ProviderType.BLOCK_TAGS, registry::generate);
        this.addDataGenerator(ProviderType.LANG, registry::generate);
        return this;
    }

    public CDPRegistrate registerItemTags(ItemTagRegistry registry) {
        this.addDataGenerator(ProviderType.ITEM_TAGS, registry::generate);
        this.addDataGenerator(ProviderType.LANG, registry::generate);
        return this;
    }

    public CDPRegistrate registerFluidTags(IntrinsicTagRegistry<Fluid, RegistrateTagsProvider.IntrinsicImpl<Fluid>> registry) {
        this.addDataGenerator(ProviderType.FLUID_TAGS, registry::generate);
        this.addDataGenerator(ProviderType.LANG, registry::generate);
        return this;
    }

    public CDPRegistrate registerEntityTags(IntrinsicTagRegistry<EntityType<?>, RegistrateTagsProvider.IntrinsicImpl<EntityType<?>>> registry) {
        this.addDataGenerator(ProviderType.ENTITY_TAGS, registry::generate);
        this.addDataGenerator(ProviderType.LANG, registry::generate);
        return this;
    }

    public CDPRegistrate registerPonderLocalization(Supplier<PonderPlugin> plugin) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            PonderIndex.addPlugin((PonderPlugin)plugin.get());
            this.addDataGenerator(ProviderType.LANG, prov -> PonderIndex.getLangAccess().provideLang(this.getModid(), (arg_0, arg_1) -> ((RegistrateLangProvider)prov).add(arg_0, arg_1)));
        }
        return this;
    }

    public CDPRegistrate registerForeignLocalization(String templateLocale) {
        this.templateLocale = templateLocale;
        return this;
    }

    public CDPRegistrate registerForeignLocalization() {
        return this.registerForeignLocalization("en_us");
    }

    public CDPRegistrate registerBuiltinLocalization(String name) {
        this.addDataGenerator(ProviderType.LANG, provider -> this.generateBuiltinLocalization(name, (RegistrateLangProvider)provider));
        return this;
    }

    public CDPRegistrate registerExtraLocalization(Consumer<BiConsumer<String, String>> provideLang) {
        this.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            provideLang.accept(langConsumer);
        });
        return this;
    }

    protected void generateBuiltinLocalization(String name, RegistrateLangProvider provider) {
        ResourceLocation location = this.asResource("lang/builtin/" + name + ".json");
        Resource resource = (Resource)this.getExistingResource(PackType.CLIENT_RESOURCES).getResource(location).orElseThrow(() -> new RuntimeException("Failed to find builtin localization: " + String.valueOf(location)));
        JsonObject json = CDPRegistrate.getJsonFromResource(resource);
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            provider.add(key, value);
        }
    }

    protected ResourceManager getExistingResource(PackType type) {
        if (this.existingFileHelper == null) {
            throw new IllegalStateException("Can not get existing resource outside datagen");
        }
        return ((ExistingFileHelperAccessor)this.existingFileHelper).invokeGetManager(type);
    }

    protected static JsonObject getJsonFromResource(Resource resource) {
        JsonObject jsonObject;
        block8: {
            InputStream inputStream = resource.open();
            try {
                jsonObject = GsonHelper.parse((Reader)new InputStreamReader(inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new JsonIOException((Throwable)exception);
                }
            }
            inputStream.close();
        }
        return jsonObject;
    }

    protected void onData(GatherDataEvent event) {
        super.onData(event);
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        this.existingFileHelper = event.getExistingFileHelper();
        if (this.templateLocale != null) {
            generator.addProvider(client, (DataProvider)new ForeignLanguageProvider(this.getModid(), this.templateLocale, output, this.existingFileHelper));
        }
    }

    public <T extends BlockEntity> CreateBlockEntityBuilder<T, CDPRegistrate> blockEntity(String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity((CDPRegistrate)this.self(), name, factory);
    }

    public <T extends BlockEntity, P> CreateBlockEntityBuilder<T, P> blockEntity(P parent, String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return (CreateBlockEntityBuilder)this.entry(name, callback -> CreateBlockEntityBuilder.create((AbstractRegistrate)this, (Object)parent, (String)name, (BuilderCallback)callback, (BlockEntityBuilder.BlockEntityFactory)factory));
    }

    public <T extends Entity> CreateEntityBuilder<T, CDPRegistrate> entity(String name, EntityType.EntityFactory<T> factory, MobCategory category) {
        return this.entity((CDPRegistrate)this.self(), name, factory, category);
    }

    public <T extends Entity, P> CreateEntityBuilder<T, P> entity(P parent, String name, EntityType.EntityFactory<T> factory, MobCategory category) {
        return (CreateEntityBuilder)this.entry(name, callback -> CreateEntityBuilder.create((AbstractRegistrate)this, (Object)parent, (String)name, (BuilderCallback)callback, (EntityType.EntityFactory)factory, (MobCategory)category));
    }

    public FluidType defaultFluidType(FluidType.Properties properties, final ResourceLocation stillTexture, final ResourceLocation flowingTexture) {
        return new FluidType(this, properties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return flowingTexture;
                    }
                });
            }
        };
    }

    public <T extends BaseFlowingFluid> FluidBuilder<T, CDPRegistrate> virtualFluid(String name, FluidBuilder.FluidTypeFactory type, NonNullFunction<BaseFlowingFluid.Properties, T> source, NonNullFunction<BaseFlowingFluid.Properties, T> flowingFactory) {
        return (FluidBuilder)this.entry(name, callback -> new VirtualFluidBuilder(this.self(), (Object)((CDPRegistrate)this.self()), name, callback, this.asResource("fluid/" + name + "_still"), this.asResource("fluid/" + name + "_flow"), type, source, flowingFactory));
    }

    public <T extends BaseFlowingFluid> FluidBuilder<T, CDPRegistrate> virtualFluid(String name, ResourceLocation stillTexture, ResourceLocation flowTexture, FluidBuilder.FluidTypeFactory typeFactory, NonNullFunction<BaseFlowingFluid.Properties, T> sourceFactory, NonNullFunction<BaseFlowingFluid.Properties, T> flowingFactory) {
        return (FluidBuilder)this.entry(name, callback -> new VirtualFluidBuilder(this.self(), (Object)((CDPRegistrate)this.self()), name, callback, stillTexture, flowTexture, typeFactory, sourceFactory, flowingFactory));
    }

    public FluidBuilder<VirtualFluid, CDPRegistrate> virtualFluid(String name) {
        return (FluidBuilder)this.entry(name, callback -> new VirtualFluidBuilder(this.self(), (Object)((CDPRegistrate)this.self()), name, callback, this.asResource("fluid/" + name + "_still"), this.asResource("fluid/" + name + "_flow"), this::defaultFluidType, VirtualFluid::createSource, VirtualFluid::createFlowing));
    }

    public FluidBuilder<VirtualFluid, CDPRegistrate> virtualFluid(String name, ResourceLocation stillTexture, ResourceLocation flowTexture) {
        return (FluidBuilder)this.entry(name, callback -> new VirtualFluidBuilder(this.self(), (Object)((CDPRegistrate)this.self()), name, callback, stillTexture, flowTexture, this::defaultFluidType, VirtualFluid::createSource, VirtualFluid::createFlowing));
    }

    public FluidBuilder<BaseFlowingFluid.Flowing, CDPRegistrate> fluid(String name) {
        return this.fluid(name, this.asResource("fluid/" + name + "_still"), this.asResource("fluid/" + name + "_flow"));
    }

    public FluidBuilder<BaseFlowingFluid.Flowing, CDPRegistrate> fluid(String name, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(name, this.asResource("fluid/" + name + "_still"), this.asResource("fluid/" + name + "_flow"), typeFactory);
    }

    public <T extends MountedItemStorageType<?>> SimpleBuilder<MountedItemStorageType<?>, T, CDPRegistrate> mountedItemStorage(String name, Supplier<T> supplier) {
        return (SimpleBuilder)this.entry(name, callback -> new SimpleBuilder((AbstractRegistrate)this, (Object)this, name, callback, CreateRegistries.MOUNTED_ITEM_STORAGE_TYPE, supplier).byBlock(MountedItemStorageType.REGISTRY));
    }

    public <T extends MountedFluidStorageType<?>> SimpleBuilder<MountedFluidStorageType<?>, T, CDPRegistrate> mountedFluidStorage(String name, Supplier<T> supplier) {
        return (SimpleBuilder)this.entry(name, callback -> new SimpleBuilder((AbstractRegistrate)this, (Object)this, name, callback, CreateRegistries.MOUNTED_FLUID_STORAGE_TYPE, supplier).byBlock(MountedFluidStorageType.REGISTRY));
    }

    public <T extends DisplaySource> SimpleBuilder<DisplaySource, T, CDPRegistrate> displaySource(String name, Supplier<T> supplier) {
        return (SimpleBuilder)this.entry(name, callback -> new SimpleBuilder((AbstractRegistrate)this, (Object)this, name, callback, CreateRegistries.DISPLAY_SOURCE, supplier).byBlock(DisplaySource.BY_BLOCK).byBlockEntity(DisplaySource.BY_BLOCK_ENTITY));
    }

    public <T extends DisplayTarget> SimpleBuilder<DisplayTarget, T, CDPRegistrate> displayTarget(String name, Supplier<T> supplier) {
        return (SimpleBuilder)this.entry(name, callback -> new SimpleBuilder((AbstractRegistrate)this, (Object)this, name, callback, CreateRegistries.DISPLAY_TARGET, supplier).byBlock(DisplayTarget.BY_BLOCK).byBlockEntity(DisplayTarget.BY_BLOCK_ENTITY));
    }

    public CustomStatBuilder<CDPRegistrate> customStat(String name, Supplier<ResourceLocation> supplier) {
        return (CustomStatBuilder)this.entry(name, callback -> new CustomStatBuilder<CDPRegistrate>(this, this, name, (BuilderCallback)callback, supplier));
    }

    public <T extends ArmInteractionPointType> ArmInteractionPointBuilder<T, CDPRegistrate> armInteractionPoint(String name, Supplier<T> supplier) {
        return (ArmInteractionPointBuilder)this.entry(name, callback -> new ArmInteractionPointBuilder(this, this, name, (BuilderCallback)callback, supplier));
    }
}

